<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Exception;

use RtmMailVendor\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;

final class MissingColumnException extends ORMException
{
    public static function fromColumnSourceAndTarget(string $column, string $source, string $target): self
    {
        return new self(sprintf(
            'Column name "%s" referenced for relation from %s towards %s does not exist.',
            $column,
            $source,
            $target
        ));
    }
}
