<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Event;

use RtmMailVendor\Dependencies\Doctrine\Common\EventArgs;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Schema;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Table;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\ClassMetadata;

/**
 * Event Args used for the Events::postGenerateSchemaTable event.
 *
 * @link        www.doctrine-project.com
 */
class GenerateSchemaTableEventArgs extends EventArgs
{
    /** @var ClassMetadata */
    private $classMetadata;

    /** @var Schema */
    private $schema;

    /** @var Table */
    private $classTable;

    public function __construct(ClassMetadata $classMetadata, Schema $schema, Table $classTable)
    {
        $this->classMetadata = $classMetadata;
        $this->schema        = $schema;
        $this->classTable    = $classTable;
    }

    /** @return ClassMetadata */
    public function getClassMetadata()
    {
        return $this->classMetadata;
    }

    /** @return Schema */
    public function getSchema()
    {
        return $this->schema;
    }

    /** @return Table */
    public function getClassTable()
    {
        return $this->classTable;
    }
}
