<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\EntityManagerProvider;

use RtmMailVendor\Dependencies\Doctrine\ORM\EntityManagerInterface;
use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\EntityManagerProvider;

final class SingleManagerProvider implements EntityManagerProvider
{
    /** @var EntityManagerInterface */
    private $entityManager;

    /** @var string */
    private $defaultManagerName;

    public function __construct(EntityManagerInterface $entityManager, string $defaultManagerName = 'default')
    {
        $this->entityManager      = $entityManager;
        $this->defaultManagerName = $defaultManagerName;
    }

    public function getDefaultManager(): EntityManagerInterface
    {
        return $this->entityManager;
    }

    public function getManager(string $name): EntityManagerInterface
    {
        if ($name !== $this->defaultManagerName) {
            throw UnknownManagerException::unknownManager($name, [$this->defaultManagerName]);
        }

        return $this->entityManager;
    }
}
