<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST;

/**
 * SubselectIdentificationVariableDeclaration ::= AssociationPathExpression ["AS"] AliasIdentificationVariable
 *
 * @link    www.doctrine-project.org
 */
class SubselectIdentificationVariableDeclaration
{
    /** @var PathExpression */
    public $associationPathExpression;

    /** @var string */
    public $aliasIdentificationVariable;

    /**
     * @param PathExpression $associationPathExpression
     * @param string         $aliasIdentificationVariable
     */
    public function __construct($associationPathExpression, $aliasIdentificationVariable)
    {
        $this->associationPathExpression   = $associationPathExpression;
        $this->aliasIdentificationVariable = $aliasIdentificationVariable;
    }
}
