<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST\Functions;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Types\Type;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Types\Types;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST\Node;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST\TypedExpression;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\Parser;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\SqlWalker;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\TokenType;

/**
 * "LENGTH" "(" StringPrimary ")"
 *
 * @link    www.doctrine-project.org
 */
class LengthFunction extends FunctionNode implements TypedExpression
{
    /** @var Node */
    public $stringPrimary;

    /** @inheritDoc */
    public function getSql(SqlWalker $sqlWalker)
    {
        return $sqlWalker->getConnection()->getDatabasePlatform()->getLengthExpression(
            $sqlWalker->walkSimpleArithmeticExpression($this->stringPrimary)
        );
    }

    /** @inheritDoc */
    public function parse(Parser $parser)
    {
        $parser->match(TokenType::T_IDENTIFIER);
        $parser->match(TokenType::T_OPEN_PARENTHESIS);

        $this->stringPrimary = $parser->StringPrimary();

        $parser->match(TokenType::T_CLOSE_PARENTHESIS);
    }

    public function getReturnType(): Type
    {
        return Type::getType(Types::INTEGER);
    }
}
