<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST\Functions;

use RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST\Node;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\Parser;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\SqlWalker;

/**
 * Abstract Function Node.
 *
 * @link    www.doctrine-project.org
 *
 * @psalm-consistent-constructor
 */
abstract class FunctionNode extends Node
{
    /** @var string */
    public $name;

    /** @param string $name */
    public function __construct($name)
    {
        $this->name = $name;
    }

    /** @return string */
    abstract public function getSql(SqlWalker $sqlWalker);

    /**
     * @param SqlWalker $sqlWalker
     *
     * @return string
     */
    public function dispatch($sqlWalker)
    {
        return $sqlWalker->walkFunction($this);
    }

    /** @return void */
    abstract public function parse(Parser $parser);
}
