<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST;

/**
 * ConditionalExpression ::= ConditionalTerm {"OR" ConditionalTerm}*
 *
 * @link    www.doctrine-project.org
 */
class ConditionalExpression extends Node
{
    /** @var mixed[] */
    public $conditionalTerms = [];

    /** @param mixed[] $conditionalTerms */
    public function __construct(array $conditionalTerms)
    {
        $this->conditionalTerms = $conditionalTerms;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($sqlWalker)
    {
        return $sqlWalker->walkConditionalExpression($this);
    }
}
