<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Query\AST;

/**
 * CollectionMemberExpression ::= EntityExpression ["NOT"] "MEMBER" ["OF"] CollectionValuedPathExpression
 *
 * @link    www.doctrine-project.org
 */
class CollectionMemberExpression extends Node
{
    /** @var mixed */
    public $entityExpression;

    /** @var PathExpression */
    public $collectionValuedPathExpression;

    /** @var bool */
    public $not;

    /**
     * @param mixed          $entityExpr
     * @param PathExpression $collValuedPathExpr
     */
    public function __construct($entityExpr, $collValuedPathExpr, bool $not = false)
    {
        $this->entityExpression               = $entityExpr;
        $this->collectionValuedPathExpression = $collValuedPathExpr;
        $this->not                            = $not;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($walker)
    {
        return $walker->walkCollectionMemberExpression($this);
    }
}
