<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Persisters;

use RtmMailVendor\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;

class PersisterException extends ORMException
{
    /**
     * @param string $class
     * @param string $associationName
     *
     * @return PersisterException
     */
    public static function matchingAssocationFieldRequiresObject($class, $associationName)
    {
        return new self(sprintf(
            'Cannot match on %s::%s with a non-object value. Matching objects by id is ' .
            'not compatible with matching on an in-memory collection, which compares objects by reference.',
            $class,
            $associationName
        ));
    }
}
