<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Mapping;

use Attribute;
use RtmMailVendor\Dependencies\Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("PROPERTY")
 */
#[Attribute(Attribute::TARGET_PROPERTY)]
final class SequenceGenerator implements MappingAttribute
{
    /**
     * @var string|null
     * @readonly
     */
    public $sequenceName;

    /**
     * @var int
     * @readonly
     */
    public $allocationSize = 1;

    /**
     * @var int
     * @readonly
     */
    public $initialValue = 1;

    public function __construct(
        ?string $sequenceName = null,
        int $allocationSize = 1,
        int $initialValue = 1
    ) {
        $this->sequenceName   = $sequenceName;
        $this->allocationSize = $allocationSize;
        $this->initialValue   = $initialValue;
    }
}
