<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Mapping;

use Attribute;
use RtmMailVendor\Dependencies\Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;
use RtmMailVendor\Dependencies\Doctrine\ORM\EntityRepository;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("CLASS")
 */
#[Attribute(Attribute::TARGET_CLASS)]
final class MappedSuperclass implements MappingAttribute
{
    /**
     * @var string|null
     * @psalm-var class-string<EntityRepository>|null
     * @readonly
     */
    public $repositoryClass;

    /** @psalm-param class-string<EntityRepository>|null $repositoryClass */
    public function __construct(?string $repositoryClass = null)
    {
        $this->repositoryClass = $repositoryClass;
    }
}
