<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Mapping;

/**
 * Is used to map the columns specified in the SELECT list of the query to the properties or fields of the entity class.
 *
 * @Annotation
 * @Target("ANNOTATION")
 */
final class FieldResult implements MappingAttribute
{
    /**
     * Name of the column in the SELECT clause.
     *
     * @var string
     */
    public $name;

    /**
     * Name of the persistent field or property of the class.
     *
     * @var string
     */
    public $column;
}
