<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Exception;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\AbstractPlatform;
use RtmMailVendor\Dependencies\Doctrine\ORM\Exception\ORMException;

use function get_debug_type;
use function sprintf;

final class CannotGenerateIds extends ORMException
{
    public static function withPlatform(AbstractPlatform $platform): self
    {
        return new self(sprintf(
            'Platform %s does not support generating identifiers',
            get_debug_type($platform)
        ));
    }
}
