<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Driver;

use RtmMailVendor\Dependencies\Doctrine\Deprecations\Deprecation;
use RtmMailVendor\Dependencies\Doctrine\Persistence\Mapping\Driver\FileLocator;
use RtmMailVendor\Dependencies\Doctrine\Persistence\Mapping\Driver\PHPDriver as CommonPHPDriver;

/**
 * {@inheritDoc}
 *
 * @deprecated this driver will be removed, use StaticPHPDriver or other mapping drivers instead.
 */
class PHPDriver extends CommonPHPDriver
{
    /** @param string|string[]|FileLocator $locator */
    public function __construct($locator)
    {
        Deprecation::trigger(
            'doctrine/orm',
            'https://github.com/doctrine/orm/issues/9277',
            'PHPDriver is deprecated, use StaticPHPDriver or other mapping drivers instead.'
        );

        parent::__construct($locator);
    }
}
