<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Internal\Hydration;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Exception;
use RtmMailVendor\Dependencies\Doctrine\ORM\Exception\MultipleSelectorsFoundException;

use function array_column;
use function count;

/**
 * Hydrator that produces one-dimensional array.
 */
final class ScalarColumnHydrator extends AbstractHydrator
{
    /**
     * {@inheritDoc}
     *
     * @throws MultipleSelectorsFoundException
     * @throws Exception
     */
    protected function hydrateAllData(): array
    {
        if (count($this->resultSetMapping()->fieldMappings) > 1) {
            throw MultipleSelectorsFoundException::create($this->resultSetMapping()->fieldMappings);
        }

        $result = $this->statement()->fetchAllNumeric();

        return array_column($result, 0);
    }
}
