<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Exception;

use function sprintf;

final class NamedNativeQueryNotFound extends ORMException implements ConfigurationException
{
    public static function fromName(string $name): self
    {
        return new self(sprintf(
            'Could not find a named native query by the name "%s"',
            $name
        ));
    }
}
