<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache;

/**
 * Defines the contract for a cache region which will specifically be used to store entity "update timestamps".
 */
interface TimestampRegion extends Region
{
    /**
     * Update a specific key into the cache region.
     *
     * @return void
     *
     * @throws LockException Indicates a problem accessing the region.
     */
    public function update(CacheKey $key);
}
