<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Region;

use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\CacheKey;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\TimestampCacheEntry;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\TimestampRegion;

/**
 * Tracks the timestamps of the most recent updates to particular keys.
 */
class UpdateTimestampCache extends DefaultRegion implements TimestampRegion
{
    /**
     * {@inheritDoc}
     */
    public function update(CacheKey $key)
    {
        $this->put($key, new TimestampCacheEntry());
    }
}
