<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister\Entity;

use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Exception\CannotUpdateReadOnlyEntity;
use RtmMailVendor\Dependencies\Doctrine\ORM\Proxy\DefaultProxyClassNameResolver;

/**
 * Specific read-only region entity persister
 */
class ReadOnlyCachedEntityPersister extends NonStrictReadWriteCachedEntityPersister
{
    /**
     * {@inheritDoc}
     */
    public function update($entity)
    {
        throw CannotUpdateReadOnlyEntity::fromEntity(DefaultProxyClassNameResolver::getClass($entity));
    }
}
