<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister\Entity;

use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\EntityCacheKey;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\EntityHydrator;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister\CachedPersister;
use RtmMailVendor\Dependencies\Doctrine\ORM\Persisters\Entity\EntityPersister;

/**
 * Interface for second level cache entity persisters.
 */
interface CachedEntityPersister extends CachedPersister, EntityPersister
{
    /** @return EntityHydrator */
    public function getEntityHydrator();

    /**
     * @param object $entity
     *
     * @return bool
     */
    public function storeEntityCache($entity, EntityCacheKey $key);
}
