<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister\Collection;

use RtmMailVendor\Dependencies\Doctrine\Common\Collections\Collection;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\CollectionCacheKey;
use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister\CachedPersister;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\ClassMetadata;
use RtmMailVendor\Dependencies\Doctrine\ORM\PersistentCollection;
use RtmMailVendor\Dependencies\Doctrine\ORM\Persisters\Collection\CollectionPersister;

/**
 * Interface for second level cache collection persisters.
 */
interface CachedCollectionPersister extends CachedPersister, CollectionPersister
{
    /** @return ClassMetadata */
    public function getSourceEntityMetadata();

    /** @return ClassMetadata */
    public function getTargetEntityMetadata();

    /**
     * Loads a collection from cache
     *
     * @return mixed[]|null
     */
    public function loadCollectionCache(PersistentCollection $collection, CollectionCacheKey $key);

    /**
     * Stores a collection into cache
     *
     * @param mixed[]|Collection $elements
     *
     * @return void
     */
    public function storeCollectionCache(CollectionCacheKey $key, $elements);
}
