<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Persister;

use RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Region;

/**
 * Interface for persister that support second level cache.
 */
interface CachedPersister
{
    /**
     * Perform whatever processing is encapsulated here after completion of the transaction.
     *
     * @return void
     */
    public function afterTransactionComplete();

    /**
     * Perform whatever processing is encapsulated here after completion of the rolled-back.
     *
     * @return void
     */
    public function afterTransactionRolledBack();

    /**
     * Gets the The region access.
     *
     * @return Region
     */
    public function getCacheRegion();
}
