<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\ORM\Cache\Exception;

use function sprintf;

class CannotUpdateReadOnlyCollection extends CacheException
{
    public static function fromEntityAndField(string $sourceEntity, string $fieldName): self
    {
        return new self(sprintf(
            'Cannot update a readonly collection "%s#%s"',
            $sourceEntity,
            $fieldName
        ));
    }
}
