<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Repository;

use RtmMailVendor\Dependencies\Doctrine\ORM\EntityManagerInterface;
use RtmMailVendor\Dependencies\Doctrine\ORM\EntityRepository;
use RtmMailVendor\Dependencies\Doctrine\ORM\Repository\RepositoryFactory;
use RtmMailVendor\Dependencies\Doctrine\Persistence\ObjectRepository;
use ReflectionMethod;

if ((new ReflectionMethod(RepositoryFactory::class, 'getRepository'))->hasReturnType()) {
    // ORM >= 3
    /** @internal */
    trait RepositoryFactoryCompatibility
    {
        /**
         * Gets the repository for an entity class.
         *
         * @param class-string<T> $entityName
         *
         * @return EntityRepository<T>
         *
         * @template T of object
         */
        public function getRepository(EntityManagerInterface $entityManager, string $entityName): EntityRepository
        {
            return $this->doGetRepository($entityManager, $entityName, true);
        }
    }
} else {
    // ORM 2
    /** @internal */
    trait RepositoryFactoryCompatibility
    {
        /** {@inheritDoc} */
        public function getRepository(EntityManagerInterface $entityManager, $entityName): ObjectRepository
        {
            return $this->doGetRepository($entityManager, $entityName, false);
        }
    }
}
