<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Middleware;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver as DriverInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Middleware;
use RtmMailVendor\Dependencies\Symfony\Bridge\Doctrine\Middleware\Debug\DebugDataHolder;
use RtmMailVendor\Dependencies\Symfony\Bridge\Doctrine\Middleware\Debug\Driver;
use Symfony\Component\Stopwatch\Stopwatch;

class DebugMiddleware implements Middleware, ConnectionNameAwareInterface
{
    private DebugDataHolder $debugDataHolder;
    private ?Stopwatch $stopwatch;
    private string $connectionName = 'default';

    public function __construct(DebugDataHolder $debugDataHolder, ?Stopwatch $stopwatch)
    {
        $this->debugDataHolder = $debugDataHolder;
        $this->stopwatch       = $stopwatch;
    }

    public function setConnectionName(string $name): void
    {
        $this->connectionName = $name;
    }

    public function wrap(DriverInterface $driver): DriverInterface
    {
        /** @psalm-suppress InternalClass,InternalMethod */
        return new Driver($driver, $this->debugDataHolder, $this->stopwatch, $this->connectionName);
    }
}
