<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler;

use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;

/** @internal */
final class RemoveLoggingMiddlewarePass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if ($container->has('logger')) {
            return;
        }

        $container->removeDefinition('doctrine.dbal.logging_middleware');
    }
}
