<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\SchemaTool\UpdateCommand;
use RtmMailVendor\Dependencies\Symfony\Component\Console\Input\InputOption;

/**
 * Command to generate the SQL needed to update the database schema to match
 * the current mapping information.
 *
 * @deprecated use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\SchemaTool\UpdateCommand instead
 */
class UpdateSchemaDoctrineCommand extends UpdateCommand
{
    use OrmProxyCommand;

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setName('doctrine:schema:update');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }
}
