<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\SchemaTool\DropCommand;
use RtmMailVendor\Dependencies\Symfony\Component\Console\Input\InputOption;

/**
 * Command to drop the database schema for a set of classes based on their mappings.
 *
 * @deprecated use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\SchemaTool\DropCommand instead
 */
class DropSchemaDoctrineCommand extends DropCommand
{
    use OrmProxyCommand;

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setName('doctrine:schema:drop')
            ->setDescription('Executes (or dumps) the SQL needed to drop the current database schema');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }
}
