<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\ResultCommand;
use RtmMailVendor\Dependencies\Symfony\Component\Console\Input\InputOption;

/**
 * Command to clear the result cache of the various cache drivers.
 *
 * @deprecated use RtmMailVendor\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\ResultCommand instead
 */
class ClearResultCacheDoctrineCommand extends ResultCommand
{
    use OrmProxyCommand;

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setName('doctrine:cache:clear-result')
            ->setDescription('Clears result cache for an entity manager');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }
}
