<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Visitor;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Column;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\ForeignKeyConstraint;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Index;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Schema;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SchemaException;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Sequence;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Table;

/**
 * Schema Visitor used for Validation or Generation purposes.
 *
 * @deprecated
 */
interface Visitor
{
    /**
     * @return void
     *
     * @throws SchemaException
     */
    public function acceptSchema(Schema $schema);

    /** @return void */
    public function acceptTable(Table $table);

    /** @return void */
    public function acceptColumn(Table $table, Column $column);

    /**
     * @return void
     *
     * @throws SchemaException
     */
    public function acceptForeignKey(Table $localTable, ForeignKeyConstraint $fkConstraint);

    /** @return void */
    public function acceptIndex(Table $table, Index $index);

    /** @return void */
    public function acceptSequence(Sequence $sequence);
}
