<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Exception;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class TableAlreadyExists extends SchemaException
{
    public static function new(string $tableName): self
    {
        return new self(
            sprintf('The table with name "%s" already exists.', $tableName),
            self::TABLE_ALREADY_EXISTS,
        );
    }
}
