<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Exception;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class IndexNameInvalid extends SchemaException
{
    public static function new(string $indexName): self
    {
        return new self(
            sprintf('Invalid index name "%s" given, has to be [a-zA-Z0-9_].', $indexName),
            self::INDEX_INVALID_NAME,
        );
    }
}
