<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\Exception;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class ColumnDoesNotExist extends SchemaException
{
    public static function new(string $columnName, string $table): self
    {
        return new self(
            sprintf('There is no column with name "%s" on table "%s".', $columnName, $table),
            self::COLUMN_DOESNT_EXIST,
        );
    }
}
