<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Query\ForUpdate;

final class ConflictResolutionMode
{
    /**
     * Wait for the row to be unlocked
     */
    public const ORDINARY = 0;

    /**
     * Skip the row if it is locked
     */
    public const SKIP_LOCKED = 1;

    /**
     * This class cannot be instantiated.
     *
     * @codeCoverageIgnore
     */
    private function __construct()
    {
    }
}
