<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Portability;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Middleware\AbstractStatementMiddleware;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Result as ResultInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Statement as DriverStatement;

/**
 * Portability wrapper for a Statement.
 */
final class Statement extends AbstractStatementMiddleware
{
    private Converter $converter;

    /**
     * Wraps <tt>Statement</tt> and applies portability measures.
     */
    public function __construct(DriverStatement $stmt, Converter $converter)
    {
        parent::__construct($stmt);

        $this->converter = $converter;
    }

    /**
     * {@inheritDoc}
     */
    public function execute($params = null): ResultInterface
    {
        return new Result(
            parent::execute($params),
            $this->converter,
        );
    }
}
