<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Logging;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver as DriverInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Middleware as MiddlewareInterface;
use RtmMailVendor\Dependencies\Psr\Log\LoggerInterface;

final class Middleware implements MiddlewareInterface
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function wrap(DriverInterface $driver): DriverInterface
    {
        return new Driver($driver, $this->logger);
    }
}
