<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Event\Listeners;

use RtmMailVendor\Dependencies\Doctrine\Common\EventSubscriber;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Event\ConnectionEventArgs;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Events;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Exception;

/**
 * Session init listener for executing a single SQL statement right after a connection is opened.
 *
 * @deprecated Implement a middleware instead.
 */
class SQLSessionInit implements EventSubscriber
{
    /** @var string */
    protected $sql;

    /** @param string $sql */
    public function __construct($sql)
    {
        $this->sql = $sql;
    }

    /**
     * @return void
     *
     * @throws Exception
     */
    public function postConnect(ConnectionEventArgs $args)
    {
        $args->getConnection()->executeStatement($this->sql);
    }

    /**
     * {@inheritDoc}
     */
    public function getSubscribedEvents()
    {
        return [Events::postConnect];
    }
}
