<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Driver;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Connection;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\API\ExceptionConverter;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\API\SQLite;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\AbstractPlatform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\SqlitePlatform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SqliteSchemaManager;
use RtmMailVendor\Dependencies\Doctrine\Deprecations\Deprecation;

use function assert;

/**
 * Abstract base implementation of the {@see Doctrine\DBAL\Driver} interface for SQLite based drivers.
 */
abstract class AbstractSQLiteDriver implements Driver
{
    /**
     * {@inheritDoc}
     */
    public function getDatabasePlatform()
    {
        return new SqlitePlatform();
    }

    /**
     * {@inheritDoc}
     *
     * @deprecated Use {@link SqlitePlatform::createSchemaManager()} instead.
     */
    public function getSchemaManager(Connection $conn, AbstractPlatform $platform)
    {
        Deprecation::triggerIfCalledFromOutside(
            'doctrine/dbal',
            'https://github.com/doctrine/dbal/pull/5458',
            'AbstractSQLiteDriver::getSchemaManager() is deprecated.'
                . ' Use SqlitePlatform::createSchemaManager() instead.',
        );

        assert($platform instanceof SqlitePlatform);

        return new SqliteSchemaManager($conn, $platform);
    }

    public function getExceptionConverter(): ExceptionConverter
    {
        return new SQLite\ExceptionConverter();
    }
}
