<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\Driver;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Connection;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\API\ExceptionConverter as ExceptionConverterInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\API\SQLSrv\ExceptionConverter;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\AbstractPlatform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\SQLServer2012Platform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\SQLServerPlatform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\SQLServerSchemaManager;
use RtmMailVendor\Dependencies\Doctrine\Deprecations\Deprecation;

use function assert;

/**
 * Abstract base implementation of the {@see Driver} interface for Microsoft SQL Server based drivers.
 */
abstract class AbstractSQLServerDriver implements Driver
{
    /**
     * {@inheritDoc}
     */
    public function getDatabasePlatform()
    {
        return new SQLServer2012Platform();
    }

    /**
     * {@inheritDoc}
     *
     * @deprecated Use {@link SQLServerPlatform::createSchemaManager()} instead.
     */
    public function getSchemaManager(Connection $conn, AbstractPlatform $platform)
    {
        Deprecation::triggerIfCalledFromOutside(
            'doctrine/dbal',
            'https://github.com/doctrine/dbal/pull/5458',
            'AbstractSQLServerDriver::getSchemaManager() is deprecated.'
                . ' Use SQLServerPlatform::createSchemaManager() instead.',
        );

        assert($platform instanceof SQLServerPlatform);

        return new SQLServerSchemaManager($conn, $platform);
    }

    public function getExceptionConverter(): ExceptionConverterInterface
    {
        return new ExceptionConverter();
    }
}
