<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Doctrine\DBAL\ArrayParameters\Exception;

use RtmMailVendor\Dependencies\Doctrine\DBAL\ArrayParameters\Exception;
use LogicException;

use function sprintf;

/** @psalm-immutable */
class MissingNamedParameter extends LogicException implements Exception
{
    public static function new(string $name): self
    {
        return new self(
            sprintf('Named parameter "%s" does not have a bound value.', $name),
        );
    }
}
