<?php
/**
 * @var array $smtp
 * @var array $settings
 * @var bool $block_mails
 * @var bool $edit_mails
 * @var bool $sender_options
 * @var array $mail_capability
 * @var bool $cron_enabled
 * @var string $cron_schedule
 * @var bool $clear_deleted_events
 */


?>
<div class="wrap" id="rtm-mail">
    <?php include 'header.php'; ?>
    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <p class="heading rtm-heading"><?php echo __('Settings', 'rtm-mail'); ?></p>
            <p class="rtm-heading-description"><?php echo __('On this page you can change the settings of the WP Mail Logger. Be sure to look through all the settings this plugin has to offer.', 'rtm-mail'); ?></p>
            <h1 class="notice-header"><?php echo __('Settings', 'rtm-mail'); ?></h1>
        </div>
        <div id="notice-container"></div>
        <hr>
        <div class="rtm-mail-page-content">
            <form id="rtm-mail-settings" action="" method="post">
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Block mails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('When this option is enabled every mail sent inside your site will be blocked and logged. If this option is disabled every mail will be automatically send after it has been logged.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input checkbox-input">
                        <label class="option-switch">
                            <input type="checkbox" class="option-checkbox"
                                   name="block_mails" <?php echo checked(1, filter_var($block_mails, FILTER_VALIDATE_BOOLEAN), false); ?> />
                            <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Edit sent emails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('If you want you can choose if anyone can edit emails that have already been sent, if this is disabled no one can edit the email when it has been sent by someone.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input checkbox-input">
                        <label class="option-switch">
                            <input type="checkbox" class="option-checkbox"
                                   name="edit_mails" <?php echo checked(1, filter_var($edit_mails, FILTER_VALIDATE_BOOLEAN), false); ?> />
                            <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Sender options', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('If you want you can set default sender options, this includes the mail title and the sender address. If you leave these fields blank the plugin will use the site name as mail title and the admin address as sender address.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <div class="sender-preset-input" style="display: block;">
                            <div class="sender-input-box">
                                <p class="edit-input-label"><?php echo __('Mail title', 'rtm-mail'); ?></p>
                                <input type="text" name="sender_options[title]" id="sender_preset_title"
                                       value="<?php echo ( $sender_options != null && ! empty($sender_options['title']) ) ? $sender_options['title'] : ''; ?>"
                                       class="edit-input-text edit-preset-text"/>
                            </div>
                            <div class="sender-input-box">
                                <p class="edit-input-label"><?php echo __('Sender address', 'rtm-mail'); ?></p>
                                <input type="text" name="sender_options[address]" id="sender_preset_address"
                                       value="<?php echo ( $sender_options != null && ! empty($sender_options['address']) ) ? $sender_options['address'] : ''; ?>"
                                       class="edit-input-text edit-preset-text"/>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Address for outgoing emails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('You can add an adress to the CC/BCC/Recipient for every outgoing email, click on the "+" to add more addresses.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <div class="option-outgoing outgoing-email">
                            <table class="outgoing-mail-table">
                                <tbody id="outgoing__list">
                                <?php
                                if (isset($settings['addresses']) && ! empty($settings['addresses'])) {
                                    foreach ($settings['addresses'] as $index => $address) {
                                        ?>
                                        <tr class="outgoing-mail-row" data-boxid="<?php echo $index; ?>">
                                            <td class="outgoing-mail-cell email-cell">
                                                <input type="text" name="option_email[]" class="option-email"
                                                       placeholder="<?php echo __('Type an address', 'rtm-mail'); ?>"
                                                       value="<?php echo $address['address']; ?>"/>
                                            </td>
                                            <td class="outgoing-mail-cell type-cell">
                                                <select class="outgoing_type" name="outgoing_type[]">
                                                    <option value="cc" <?php echo $address['type'] === 'cc' ? ' selected="selected"' : ''; ?>>
                                                        CC
                                                    </option>
                                                    <option value="bcc" <?php echo $address['type'] === 'bcc' ? ' selected="selected"' : ''; ?>>
                                                        BCC
                                                    </option>
                                                    <option value="recipient" <?php echo $address['type'] === 'recipient' ? ' selected="selected"' : ''; ?>>
                                                        Recipient
                                                    </option>
                                                </select>
                                            </td>
                                            <td class="outgoing-mail-cell button-cell">
                                                <?php
                                                if ($index === 0) {
                                                    ?>
                                                    <button type="button" id="add_outgoing_field" name="add_outgoing"
                                                            class="button button-invert">+
                                                    </button>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <button type="button" name="remove_outgoing"
                                                            class="button button-invert-remove remove_outgoing_field"
                                                            data-boxid="<?php echo $index; ?>"
                                                            style="padding: 0 12px">-
                                                    </button>
                                                    <?php
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    ?>
                                    <tr class="outgoing-mail-row">
                                        <td class="outgoing-mail-cell email-cell">
                                            <input type="text" name="option_email[]" class="option-email"
                                                   placeholder="<?php echo __('Type an address', 'rtm-mail'); ?>"/>
                                        </td>
                                        <td class="outgoing-mail-cell type-cell">
                                            <select class="outgoing_type" name="outgoing_type[]">
                                                <option value="cc">CC</option>
                                                <option value="bcc">BCC</option>
                                                <option value="recipient">Recipient</option>
                                            </select>
                                        </td>
                                        <td class="outgoing-mail-cell button-cell">
                                            <button type="button" id="add_outgoing_field" name="add_outgoing"
                                                    class="button button-invert">+
                                            </button>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Capability access', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('Here you can choose which role capabilities can access the mail overview and details page. People with this capability can also edit, send and delete mails.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <?php
                        global $wp_roles;
                        $all_capabilities = [];
                        foreach ($wp_roles->roles as $role) {
                            $all_capabilities = array_merge($all_capabilities, $role['capabilities']);
                        }
                        ?>
                        <div class="option-mail-capability">
                            <select class="mail_capability" name="mail_capability">
                                <?php foreach ($all_capabilities as $capability => $has_capability) { ?>
                                    <option value="<?php echo $capability; ?>" <?php echo $mail_capability === $capability ? 'selected="selected"' : '' ?>><?php echo $capability; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Only clear deleted logs', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('When enabled only deleted logs will be cleared from the debug events when the user clears it. If this option is disabled every debug event will be removed.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input checkbox-input">
                        <label class="option-switch">
                            <input type="checkbox" class="option-checkbox"
                                   name="clear_deleted_events" <?php echo checked(1, filter_var($clear_deleted_events, FILTER_VALIDATE_BOOLEAN), false); ?> />
                            <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Send caught mails automatically', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('With this setting you can choose to send all caught mails around a certain time. The time you can do this with is based on WordPress schedules. Keep in mind this can collide with queued emails, once the email is sent it won\'t send again. The first caught emails will be sent at the time now + the scheduled time.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <div class="settings-input-cron">
                            <label class="option-switch">
                                <input type="checkbox" class="option-checkbox"
                                       name="mail_cron_enabled" <?php echo checked(1, filter_var($cron_enabled, FILTER_VALIDATE_BOOLEAN), false); ?> />
                                <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                            </label>
                            <div class="option-send-mails-time">
                                <select class="send-mail-cron-times" name="mail_cron_schedule">
                                    <?php
                                    foreach (wp_get_schedules() as $schedule_key => $schedule) {
                                        ?>
                                        <option value="<?php echo $schedule_key; ?>" <?php echo $cron_schedule === $schedule_key ? 'selected="selected"' : '' ?>><?php echo $schedule['display']; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>

                        </div>

                    </div>
                </div>
                <input type="hidden" name="_wpnonce"
                       value="<?php echo esc_attr(wp_create_nonce('rtm_mail_save_settings')); ?>"/>
                <?php submit_button(__('Save settings', 'rtm-mail'), '', 'save_settings', false, [ 'id' => 'save-settings' ]); ?>
            </form>
            <div style="margin-top: 20px;"></div>
            <form id="smtp-test-form">
                <div class="option-test-smtp">
                    <input type="hidden" name="_wpnonce"
                           value="<?php echo esc_attr(wp_create_nonce('rtm_mail_test_smtp')); ?>"/>
                    <button type="submit" id="test-smtp" class="button button-secondary">Test SMTP Connection</button>
                </div>
            </form>
            <div style="margin-top: 20px;"></div>
            <form id="dns-test-form">
                <div class="option-test-dns">
                    <input type="hidden" name="_wpnonce"
                           value="<?php echo esc_attr(wp_create_nonce('rtm_mail_test_dns')); ?>"/>
                    <button type="submit" id="test-dns" class="button button-secondary">DNS Report</button>
                </div>
            </form>
            <!-- DNS Report Modal -->
            <div class="modal dns-report-modal" id="dns_report_modal">
                <div class="modal-container">
                    <div class="modal-header">
                        <h3>DNS Report</h3>
                        <button class="modal-close">Close</button>
                    </div>
                    <hr>
                    <div class="modal-content">
                        <div class="dns-data-container">
                            <div class="dns-section">
                                <h4>SPF Data</h4>
                                <textarea id="dns_report_text" style="height:400px; width:350px;" class="dns-report-textbox"></textarea>
                            </div>
                            <form id="dkim_form" class="dns-section">
                                <h4>DKIM Data</h4>
                                <div style="display: flex; flex-direction: column;">
                                    <div style="display: flex; align-items: center; justify-content: space-between;">
                                        <div>
                                            <label for="dkim_domain">Domain:</label>
                                            <input type="text" name="smtp_host"
                                                   value="<?php echo (isset($smtp['smtp_settings']['other']['other_smtp_host']) && !empty($smtp['smtp_settings']['other']['other_smtp_host'])) ? htmlspecialchars($smtp['smtp_settings']['other']['other_smtp_host']) : ''; ?>"
                                                   readonly>
                                        </div>
                                        <div>
                                            <label for="dkim_selector">DKIM Selector:</label>
                                            <select id="dkim_selector">
                                                <!-- Options will be populated here -->
                                            </select>
                                        </div>
                                    </div>
                                    <input type="hidden" name="_wpnonce"
                                           value="<?php echo esc_attr(wp_create_nonce('rtm_mail_test_dkim')); ?>"/>
                                    <input type="text" id="custom_dkim_selector" placeholder="Enter custom selector" style="margin-top: 20px; display: none;">
                                    <button type="submit" id="submit-dkim" class="button button-secondary" style="margin-top: 20px;">Submit DKIM Settings</button>
                                    <textarea id="dkim_report_text" style="height:300px; width:400px; display:block;" class="dkim-report-textbox"></textarea>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>





        </div>
    </div>
</div>
