<?php

/**
 * Navigation bar for the plugin's admin pages, adjusted to the new AbstractPage structure.
 *
 * @var AbstractPage $this
 *
 */

use RtmMail\Core;
use RtmMailVendor\Dependencies\WordpressModels\Page\AbstractPage;

$rtmMailPluginUrl = RTM_MAIL_PLUGIN_URL; // Assuming RTM_MAIL_PLUGIN_PATH is defined
$rtmMailVersion   = RTM_MAIL_VERSION; // Assuming RTM_MAIL_VERSION is defined
$current_page     = $this->getPageId(); // Use the providaced getter method.
$allPages         = Core::instance()->getPages();

?>
<div class="navbar">
    <div class="nav-logo">
        <img src="<?= esc_url( $rtmMailPluginUrl ) ?>assets/images/logo-icon.png" alt="wp-mail-logger logo"
             class="logo-icon"/>
        <img src="<?= esc_url( $rtmMailPluginUrl ) ?>assets/images/logo.png" alt="wp-mail-logger logo" class="logo"/>
        <span class="nav-version">v<?= esc_html( $rtmMailVersion ) ?></span>
    </div>
    <a href="#" class="nav-link mobile-link-toggle"><i class="fas fa-bars"></i></a>
    <div class="nav-menu-links">
		<?php foreach ( $allPages as $pageId => $page_data ) : ?>
			<?php if ( $this->getCapability() && current_user_can( $this->getCapability() ) ) : ?>
                <a href="<?= esc_url( get_admin_url() ) ?>admin.php?page=<?= esc_attr( $page_data->getMenuSlug() ) ?>"
                   class="nav-link <?= esc_attr( $pageId ) === $current_page ? 'nav-selected' : '' ?>"><?= esc_html( $page_data->getTitle() ) ?></a>
			<?php endif; ?>
		<?php endforeach; ?>
    </div>
</div>
<div class="navbar-mobile-container">
    <div class="navbar-mobile">
		<?php foreach ( $allPages as $pageId => $page_data ) : ?>
            <!-- Use the same adjusted condition as above for mobile nav links -->
			<?php if ( $this->getCapability() && current_user_can( $this->getCapability() ) ) : ?>
                <a href="<?= esc_url( get_admin_url() ) ?>admin.php?page=<?= esc_attr( $page_data->getMenuSlug() ) ?>"
                   class="nav-link-mobile <?= esc_attr( $pageId ) === $current_page ? 'nav-mobile-selected' : '' ?>"><?= esc_html( $page_data->getTitle() ) ?></a>
			<?php endif; ?>
		<?php endforeach; ?>
    </div>
</div>

