<?php

namespace RtmMail\Pages;

class Settings extends BasePage
{
    protected string $slug = 'settings';

    public function __construct()
    {
        parent::__construct(
            pageId: 'rtm-mail-settings',
            menuSlug: 'rtm-mail-settings',
            title: __('Settings', 'rtm-mail'),
            parent: 'rtm-mail-dashboard',
            capability: 'manage_options',
            position: 4
        );
    }
    public function doEnqueue(): void
    {
        parent::doEnqueue();
        wp_enqueue_script('settings-script', RTM_MAIL_PLUGIN_URL . 'dist/settings.js', [], false, true);
        $this->localizeScript('settings-script');
    }

    public function renderPage(): void
    {
        // Get current settings options
        $smtp = get_option('rtm_mail_smtp_settings');
        $settings = get_option('rtm_mail_settings');
        $block_mails = $settings['block_mails'] ?? false;
        $edit_mails = $settings['edit_mails'] ?? false;
        $sender_options = $settings['sender_options'] ?? null;
        $mail_capability = $settings['mail_capability'] ?? 'manage_options';
        $cron_enabled = $settings['mail_cron_enabled'] ?? false;
        $cron_schedule = $settings['mail_cron_schedule'] ?? 'hourly';
        $clear_deleted_events = $settings['clear_deleted_events'] ?? false;
        include RTM_MAIL_PLUGIN_PATH . 'src/Views/' . $this->slug . '.php';
    }
}
