<?php

namespace RtmMail\Pages;

use RtmMail\LogsTable;

/**
 * Overview - handles every user interaction for the overview page
 */
class Overview extends BasePage
{
    protected string $slug = 'overview';

    public function __construct($mail_capability)
    {
        parent::__construct(
            pageId: 'rtm-mail-overview',
            menuSlug: 'rtm-mail-overview',
            title: __('Overview', 'rtm-mail'),
            parent: 'rtm-mail-dashboard',
            capability: $mail_capability,
            position: 3
        );
    }
    public function doEnqueue(): void
    {
        parent::doEnqueue();
        wp_enqueue_script('overview-script', RTM_MAIL_PLUGIN_URL . 'dist/overview.js', [], false, true);
        $this->localizeScript('overview-script');
    }

    public function renderPage(): void
    {
        $log_table = new LogsTable();
        $log_table->prepare_items();
        $settings = get_option('rtm_mail_settings');
        include RTM_MAIL_PLUGIN_PATH . 'src/Views/' . $this->slug . '.php';
    }
}
