<?php

namespace RtmMail\Pages;

use RtmMail\EventsTable;

class Events extends BasePage
{
    protected string $slug = 'events';

    public function __construct()
    {
        parent::__construct(
            pageId: 'rtm-mail-events',
            menuSlug: 'rtm-mail-events',
            title: __('Event Logger', 'rtm-mail'),
            parent: 'rtm-mail-dashboard',
            capability: 'manage_options',
            position: 2
        );
    }

    public function doEnqueue(): void
    {
        parent::doEnqueue();
        wp_enqueue_script('events-script', RTM_MAIL_PLUGIN_URL . 'dist/events.js', [], false, true);
        $this->localizeScript('events-script');
    }

    /**
     * renderPage- Displays the page view for the user
     */
    public function renderPage(): void
    {
        $events_table = new EventsTable();
        $events_table->prepare_items();

        include RTM_MAIL_PLUGIN_PATH . 'src/Views/' . $this->slug . '.php';
    }
}
