<?php

namespace RtmMail\Pages;

use RtmMail\Helpers\EventHelper;
use RtmMail\Helpers\LogHelper;

class EventDetails extends BasePage
{
    protected string $slug = 'event_details';

    private array $event_logs;
    private array $mail_log;

    public function __construct()
    {
        parent::__construct(
            pageId: 'rtm-mail-event_details',
            menuSlug: 'rtm-mail-event_details',
            title: __('Event Details', 'rtm-mail'),
            parent: 'rtm-mail-main-menu',// doesnt show, still load
            capability: 'manage_options'
        );
    }
    public function doEnqueue(): void
    {
        parent::doEnqueue();
        wp_enqueue_script('event-details-script', RTM_MAIL_PLUGIN_URL . 'dist/eventdetails.js', [], false, true);
        $this->localizeScript('event-details');

    }

    public function renderPage(): void
    {
        // Moving data fetching into the renderPage method
        if (isset($_GET['log_id'])) {
            $log_id = sanitize_key($_GET['log_id']);
            $this->mail_log = LogHelper::get([
                'post_per_page' => -1,
                'where' => [
                    'id' => [
                        'type' => '=',
                        'value' => $log_id,
                    ],
                ],
            ]);
            $this->event_logs = EventHelper::get([
                'post_per_page' => -1,
                'search_filter' => [
                    'log_id' => true,
                ],
                's' => $log_id,
            ]);
        }
        if (isset($_GET['event_id'])) {
            $event_id = sanitize_key($_GET['event_id']);
            $this->event_logs = array_merge(EventHelper::get([
                'post_per_page' => -1,
                'search_filter' => [
                    'id' => true,
                ],
                'id' => $event_id
            ]), $this->event_logs);
        }
        $log = $this->mail_log;
        $events = $this->event_logs;
        include RTM_MAIL_PLUGIN_PATH . 'src/Views/' . $this->slug . '.php';
    }

    /**
     * build_dump - Builds the request debug block
     * @return string - HTML code block
     */
    public function buildDump($request): string
    {
        $html = '<div class="request-dump-block">';
        foreach ($request as $request_type => $request_data) {
            if (!empty($request_data)) {
                $html .= '<div class="request-dump-item">';
                $html .= '<p class="request-item-label">' . $request_type . '</p>';
                $html .= '<pre class="request-item-data">';
                $html .= $this->buildRequestData($request_data);
                $html .= '</pre>';
                $html .= '</div>';
            }
        }
        $html .= '</div>';

        return $html;
    }

    /**
     * build_request_data - Attach all request values to the request debug block
     *
     * @param $data - Incoming request data
     * @param string $html - Current html block (for recursion)
     * @param int $level - Current level of the request value (dents the values to the right)
     *
     * @return string - HTML code block
     */
    private function buildRequestData($data, string $html = '', int $level = 1): string
    {
        if (empty($html)) {
            $html = '<p><span class="request-dump-type">' . gettype($data) . ' (' . count($data) . ')</span> ';
            $html .= is_array($data) ? '[</p>' : '{</p>';
        }
        $html .= '<div class="request-dump-data" style="margin-left: calc(7px * ' . $level . ');">';
        foreach ($data as $key => $value) {
            $html .= '<p>"<span class="request-dump-key">' . $key . '</span>" => ';
            if (is_array($value) || is_object($value)) {
                $html .= '<span class="request-dump-type">' . gettype($value) . ' (' . count($value) . ')</span> ';
                $html .= is_array($value) ? '[</p>' : '{</p>';
                $html = $this->buildRequestData($value, $html, $level + 1);
            } else {
                $value = is_string($value) ? '"<span class="request-dump-value">' . $value . '</span>"' : '<span class="request-dump-value">' . $value . '</span>';
                $html .= $value . '</p>';
            }
        }
        $html .= '</div>';
        $html .= is_array($data) ? '<p>]</p>' : '<p>}</p>';

        return $html;
    }
}
