<?php

namespace RtmMail\Pages;

use RtmMail\Helpers\DashboardHelper;

/**
 * Dashboard - handles every user interaction for the dashboard page
 */
class Dashboard extends BasePage
{
    protected string $slug = 'dashboard';

    public function __construct(string $mail_capability)
    {
        parent::__construct(
            pageId: 'rtm-mail-dashboard',
            menuSlug: 'rtm-mail-dashboard',
            title: __('WP Mail Logger', 'rtm-mail'),
            capability: $mail_capability,
            position: 100,
            icon: 'dashicons-email-alt',
        );
    }
    public function doEnqueue(): void
    {
        parent::doEnqueue();
        wp_enqueue_script('dashboard-script', RTM_MAIL_PLUGIN_URL . 'dist/dashboard.js', [], false, true);
        $this->localizeScript('dashboard-script');
    }

    /**
     * renderPage - Displays the page view for the user
     */
    public function renderPage(): void
    {
        $migration_version = get_option("rtm_mail_migration_version", '');
        $settings = get_option('rtm_mail_settings');
        $mail_capability = $settings['mail_capability'] ?? 'manage_options';
        $block_mails = $settings['block_mails'] ?? false;
        $edit_mails = $settings['edit_mails'] ?? false;
        $cron_enabled = $settings['mail_cron_enabled'] ?? false;
        $cron_schedule = $settings['mail_cron_schedule'] ?? 'hourly';
        $cron_timestamp = wp_next_scheduled('rtm_mail_send_caught_logs');

        $dashboard = DashboardHelper::get();

        include RTM_MAIL_PLUGIN_PATH . 'src/Views/' . $this->slug . '.php';
    }
}
