<?php

namespace RtmMail\Pages;

use RtmMailVendor\Dependencies\WordpressModels\Page\AbstractPage;

abstract class BasePage extends AbstractPage
{

    /**
     * @inheritDoc
     */
    public function buildContext(array $context = []): array
    {
        return [];
    }

    public function doEnqueue(): void
    {
        wp_enqueue_style('fontawesome', 'https://use.fontawesome.com/releases/v5.7.0/css/all.css');
        wp_enqueue_style('intlTelInput-css', 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css');
        wp_enqueue_script('intlTelInput-js', 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js', [], false, false);
        wp_enqueue_style('rtm-mail', RTM_MAIL_PLUGIN_URL . 'assets/css/style.css');
        wp_register_script('rtm-mail', RTM_MAIL_PLUGIN_URL . 'dist/bundle.js');
    }

    protected function localizeScript($script_handle, $additional_data = []): void
    {
        // Define the common data here
        $common_data = [
            'type_address' => __('Type an address', 'rtm-mail'),
            'status_sent' => __('Sent', 'rtm-mail'),
            'status_queued' => __('Queued', 'rtm-mail'),
            'time_days' => __('day(s)', 'rtm-mail'),
            'time_hours' => __('hour(s)', 'rtm-mail'),
            'time_minutes' => __('minute(s)', 'rtm-mail'),
            'time_seconds' => __('second(s)', 'rtm-mail'),
            'wp_locale' => get_locale(),
            'wp_timezone' => (str_starts_with(wp_timezone_string(), '+') || str_starts_with(wp_timezone_string(), '-') || is_numeric(substr(wp_timezone_string(), 0, 1))) ? 'UTC' . wp_timezone_string() : wp_timezone_string(),
        ];

        // Merge additional data into the common data
        $localization_data = array_merge($common_data, $additional_data);

        // Localize the script with the merged data
        wp_localize_script($script_handle, 'rtm_mail_translation', $localization_data);
    }

    private function getCurrentPage(): string
    {
        return $this->slug;
    }
}
