<?php

namespace RtmMail\Migrations;

interface MigrationInterface {
	/**
	 * migrate - Execute the SQL for the migration
	 */
	public function migrate();

	/**
	 * rollback - Roll back the executed SQL for this migration
	 */
	public function rollback();

	/**
	 * is_migrated - Check if the migration is already done
	 * @return bool
	 */
	public function is_migrated();

	/**
	 * get_priority - Gets the priority level of the migration class
	 * @return int
	 */
	public function get_priority();
}