<?php

namespace RtmMail;

use RtmMail\Models\Entities\Log;

class LogHandler
{

    public function __construct()
    {
    }

    /**
     * Write log to db
     *
     * @param array $record
     *
     * @return void
     */
    public function write(array $record): void
    {
        if (Logger::CHANNEL != $record['channel']) {
            return;
        }

        $log = new Log();
        $log->setTitle($record['context']['title']);
        $log->setMessage($record['message']);
        $log->setSeverity($record['level']);
        $log->setSource($record['context']['source']);
        $log->setCategory($record['context']['category']);
        $log->setData($record['context']['data']);
        $log->setMetadata($record['context']['metadata']);
        $log->setTimestamp($record['datetime']);

        $log->save();
    }
}
